@php
use App\Library\FinancialLib;
@endphp

<style>
    .nav-tabs { margin: 0 !important; width: 100% !important; padding-bottom: 0 !important; }
    .nav-tabs > li { background-color: #f5f5f5; }
    .tab-content { border: 1px solid #ddd; border-top: none; }
    .tab-content .nav-tabs > li { background-color: #fff; }
    .nav-tabs > li > a { color: #ccc; padding: 25px 0; border: none; }
    .nav-tabs > li > a > i { display: block; font-size: 35px; margin-bottom: 10px; }
    .tab-content .nav-tabs > li > a { color: #ccc; padding: 25px; border: none !important; }
    .nav-tabs > li > a:hover { background-color: white; }
    .nav-tabs > li > a.active, .nav-tabs > li > a.active:hover, .nav-tabs > li > a.active:focus { color: #0065CB!important; }
    .tab-pane .table { margin-bottom: 0; }
</style>
<div id="div_dati_livello">
    @php
    $tipiVeicoli = [
        'autoveicolo' => 'car',
        'bus' => 'bus',
        'camper' => 'bus',
        'ciclomotore' => 'motorcycle',
        'motociclo' => 'motorcycle',
    ];
    $tipiSoste = [
        'std' => 'Standard',
        'gio' => 'Giornaliera',
        'fse' => 'Fine sett. (Ven-Dom)',
        'set' => 'Settimanale',
        'men' => 'Mensile',
    ];
    @endphp
    <div>
        <?php $grpVehicleTypes = $levels->groupBy('tipo_veicolo_id') ?>
        <!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist" id="veicles-tabs">
            @foreach ($grpVehicleTypes as $vehicleTypes => $levels)
            <li role="presentation" style="width: {{ 100 / $grpVehicleTypes->count() }}%;">
                <a href="#tipo-veicolo-{{ $vehicleTypes }}" 
                    aria-controls="tipo-veicolo-{{ $vehicleTypes }}" 
                    role="tab" 
                    data-toggle="tab"
                    data-vehicleTypes="{{ $vehicleTypes }}"
                    class="nav-link text-center">
                    <i class="fa fa-{{ $tipiVeicoli[$levels->first()->vehicle_type->slug] }}"></i>{!! $levels->first()->vehicle_type->nome !!}
                </a>
            </li>
            @endforeach
        </ul>
        <!-- Tab panes -->
        <div class="tab-content">
            @foreach ($grpVehicleTypes as $vehicleTypes => $levels)
            <div role="tabpanel" class="tab-pane" id="tipo-veicolo-{{ $vehicleTypes }}">
                <!-- Nav tabs -->
                <ul class="nav nav-tabs" role="tablist" id="levels-tabs" style="display: flex; white-space: nowrap; overflow-x: scroll; overflow-y: hidden; flex-wrap: unset;">
                    @foreach ($levels as $level)
                    <li role="presentation" style="float: left;">
                        <a href="#livello-{{ $level->id }}" 
                            aria-controls="livello-{{ $level->id }}" 
                            role="tab" 
                            data-toggle="tab"
                            data-livello="{{ $level->id }}"
                            class="nav-link text-center">{!! $tipiSoste[$level->tipo_sosta] !!}</a>
                    </li>
                    @endforeach
                </ul>
                <!-- Tab panes -->
                <div class="tab-content">
                    @foreach ($levels as $level)
                    <div role="tabpanel" class="tab-pane" id="livello-{{ $level->id }}">
                        <table class="table table-bordered">
                            <tbody>
                                @if ($level->tipo_sosta == 'std')
                                <tr>
                                    <th>Tariffa oraria</th>
                                    <td class="text-right">{!! FinancialLib::centToEuro($level->tariffa_oraria) !!}</td>
                                </tr>
                                <tr>
                                    <th>Tariffa minima</th>
                                    <td class="text-right">{!! FinancialLib::centToEuro($level->tariffa_minima) !!}</td>
                                </tr>
                                <tr>
                                    <th>Tempo iniziale <em>(in m)</em></th>
                                    <td class="text-right">{{ $level->tempo_gratuito }}</td>
                                </tr>
                                <tr>
                                    <th>Costo iniziale</th>
                                    <td class="text-right">{!! FinancialLib::centToEuro($level->costo_gratuito) !!}</td>
                                </tr>
                                <tr>
                                    <th>Costo massimo</th>
                                    <td class="text-right">{!! $level->costo_massimo ? FinancialLib::centToEuro($level->costo_massimo) : '-' !!}</td>
                                </tr>
                                @else
                                <tr>
                                    <th>Costo</th>
                                    <td class="text-right">{!! FinancialLib::centToEuro($level->costo_fisso) !!}</td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                    @endforeach
                </div>
            </div>
            @endforeach
        </div><!-- end of .tab-contents -->
    </div>
</div><!-- end of #div_dati_livello -->
<script>
    function updateLevel() {
        var level = $('.nav.nav-tabs#levels-tabs li a.active').data('livello');
        console.log('Updateing level...', level);
        $('[name="level_id"]').val(level);

        updateTimeCounter(level);
    }

    $(document).ready(function () {
        $('.nav.nav-tabs#veicles-tabs').find('li').first().find('a').addClass('active');
        $('.nav.nav-tabs#veicles-tabs + .tab-content').find('div').first().addClass('active');

        $('.nav.nav-tabs#levels-tabs').find('li').first().find('a').addClass('active');
        $('.nav.nav-tabs#levels-tabs + .tab-content').find('div').first().addClass('active');

        $('.nav.nav-tabs#veicles-tabs').tab();
        $('.nav.nav-tabs#levels-tabs').tab();

        $('.nav.nav-tabs#veicles-tabs').on('show.bs.tab', function (event) {
            $('.nav.nav-tabs#levels-tabs li').each(function (index, value) {
                $(value).find('a').removeClass('active');
            });
            $('.nav.nav-tabs#levels-tabs + .tab-content > div').each(function (index, value) {
                $(value).removeClass('active');
            });

            var target = $(event.target);

            $(target.attr('href')).find('.nav.nav-tabs li').first().find('a').addClass('active');
            $(target.attr('href')).find('.nav.nav-tabs + .tab-content .tab-pane').first().addClass('active');

            setVehicleType(target.data('tipoveicolo'));

            updateLevel();
        });
        $('.nav.nav-tabs#levels-tabs').on('show.bs.tab', function (event) {
            var target = $(event.target);

            var level = target.data('livello');
            $('[name="level_id"]').val(level);

            updateTimeCounter(level);
        });

        updateLevel();
    });
</script>