<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Vehicle;
use App\Models\User;

class UserVehicle extends Model
{
    protected $table = 'gl_veicoli_utenti';
    protected $fillable = [ 'veicolo_id', 'utente_id', 'fast' ];
    
    public function vehicle() {
        return $this->belongsTo(Vehicle::class, 'veicolo_id');
    }
    
    public function user() {
        return $this->belongsTo(User::class, 'utente_id');
    }
}
