<?php
use App\Library\FinancialLib;    
?>

<?php if(isset($info)): ?>
<table class="table table-bordered">
    <tbody>
        <tr>
            <th>Tariffa oraria</th>
            <td class="text-right"><?php echo FinancialLib::centToEuro($level->tariffa_oraria); ?></td>
        </tr>
        <tr>
            <th>Tariffa minima</th>
            <td class="text-right"><?php echo FinancialLib::centToEuro($level->tariffa_minima); ?></td>
        </tr>
        <tr>
            <th>Tempo iniziale <em>(in m)</em></th>
            <td class="text-right"><?php echo e($level->tempo_gratuito); ?></td>
        </tr>
        <tr>
            <th>Costo iniziale</th>
            <td class="text-right"><?php echo FinancialLib::centToEuro($level->costo_gratuito); ?></td>
        </tr>
        <tr>
            <th>Costo massimo</th>
            <td class="text-right"><?php echo $level->costo_massimo ? FinancialLib::centToEuro($level->costo_massimo) : '-'; ?></td>
        </tr>
    </tbody>
</table>

<?php else: ?>

<table class="table table-bordered">
    <tbody>
        <tr>
            <td colspan="2">Livello</td>
            <td colspan="2" class="text-right"><?php echo e($level->livello); ?></td>
        </tr>
        <tr>
            <td>Tipo veicolo</td>
            <td class="text-right"><?php echo e($level->vehicle_type->nome); ?></td>
            <td>Numero posti</td>
            <td class="text-right"><?php echo e($level->n_posti); ?></td>
        </tr>
        <tr>
            <td>Tariffa oraria</td>
            <td class="text-right"><?php echo FinancialLib::centToEuro($level->tariffa_oraria); ?></td>
            <td>Tariffa minima</td>
            <td class="text-right"><?php echo FinancialLib::centToEuro($level->tariffa_minima); ?></td>
        </tr>
        <tr>
            <td>Tempo iniziale <em>(in m)</em></td>
            <td class="text-right"><?php echo e($level->tempo_gratuito); ?></td>
            <td>Costo iniziale</td>
            <td class="text-right"><?php echo FinancialLib::centToEuro($level->costo_gratuito); ?></td>
        </tr>
        <tr>
            <td colspan="2">Costo massimo</td>
            <td colspan="2" class="text-right"><?php echo FinancialLib::centToEuro($level->costo_massimo); ?></td>
        </tr>
    </tbody>
</table>
<?php endif; ?>
