@php
use Carbon\Carbon;
use App\Library\FinancialLib;
@endphp

@extends('/emails/layouts/master')

@section('content')
<h1 style="font: 400 22px/1.5em Helvetica, Arial, sans-serif; color: #212121;">Sosta registrata con successo</h1>
<p style="margin-top: 30px; margin-bottom: 0; color: #616161; font: 300 16px/1.5em Helvetica, Arial, sans-serif;"><img alt="checked" src="{{ asset('/img/checked.png') }}"></p>
<p style="margin-top: 30px; margin-bottom: 0; color: #616161; font: 300 16px/1.5em Helvetica, Arial, sans-serif;">La creazione della tua sosta su {{ config('app.name') }} si &egrave; conclusa con successo.<br>A seguire puoi trovare i dettagli della sosta che hai appena effettuato.</p>
<p style="margin-top: 30px; margin-bottom: 0; color: #616161; font: 300 16px/1.5em Helvetica, Arial, sans-serif;"><img alt="map" src="https://maps.googleapis.com/maps/api/staticmap?center={{ $park->latlng }}&zoom=17&size=550x300&markers=color:0x0873B6|{{ $park->latlng }}&key={{ config('google.maps_api_key') }}" style=""></p>

@php
$parkType = "Standard";
switch ($park->level->tipo_sosta) {
    case 'gio':
        $parkType = "Giornaliera";
        break;
    case 'fse':
        $parkType = "Fine settimana (Ven-Dom)";
        break;
    case 'set':
        $parkType = "Settimanale";
        break;
    case 'men':
        $parkType = "Mensile";
        break;
}
$parkStart = Carbon::createFromFormat('Y-m-d H:i:s', $park->inizio);
$parkEnd = Carbon::createFromFormat('Y-m-d H:i:s', $park->fine);
$parkCost = FinancialLib::centToEuro($park->costo);
@endphp
<table style="width: 100%;">
    <tbody>
        <tr>
            <td style="padding: 10px 0; text-align: left; color: #616161; font: 300 16px/1.5em Helvetica, Arial, sans-serif;">Tipo sosta</td>
            <th style="padding: 10px 0; text-align: right; color: #616161; font: 400 16px/1.5em Helvetica, Arial, sans-serif;">{{ $parkType }}</th>
        </tr>
        <tr>
            <td style="padding: 10px 0; text-align: left; color: #616161; font: 300 16px/1.5em Helvetica, Arial, sans-serif;">Veicolo</td>
            <th style="padding: 10px 0; text-align: right; color: #616161; font: 400 16px/1.5em Helvetica, Arial, sans-serif;">{{ $park->vehicle->targa }}</th>
        </tr>
        <tr>
            <td style="padding: 10px 0; text-align: left; color: #616161; font: 300 16px/1.5em Helvetica, Arial, sans-serif;">Inizio sosta</td>
            <th style="padding: 10px 0; text-align: right; color: #616161; font: 400 16px/1.5em Helvetica, Arial, sans-serif;">{{ $parkStart->format('d/m/Y H:i:s') }}</th>
        </tr>
        <tr>
            <td style="padding: 10px 0; text-align: left; color: #616161; font: 300 16px/1.5em Helvetica, Arial, sans-serif;">Fine sosta</td>
            <th style="padding: 10px 0; text-align: right; color: #616161; font: 400 16px/1.5em Helvetica, Arial, sans-serif;">{{ $parkEnd->format('d/m/Y H:i:s') }}</th>
        </tr>
        <tr>
            <td style="padding: 10px 0; text-align: left; color: #616161; font: 300 16px/1.5em Helvetica, Arial, sans-serif;">Importo</td>
            <th style="padding: 10px 0; text-align: right; color: #616161; font: 400 16px/1.5em Helvetica, Arial, sans-serif;">{!! $parkCost !!}</th>
        </tr>
    </tbody>
</table>
@endsection