<script>
    function updateTimeCounter(level) {
        $.get("{{ url('api/levels') }}/" + level + "/timeCounter", {}, function(data) {
            $('#park-times').html(data);
            $('#park-cost').val('').parents('.row').addClass('d-none');
            $('#error').parents('.row').addClass('d-none').find('#message').html('');
        });
    }

    function setVehicleType(type) {
        $('input[name="vehicle_type_id"]').val(type);
    }

    function showError(message) {
        $('#error #message').html(message).parents('.row').removeClass('d-none');
        $('.btn.btn-outline-primary').parents('.row').addClass('d-none');
    }

    function showPayButton() {
        $('.btn.btn-outline-primary').parents('.row').removeClass('d-none');
    }
</script>
@if ($levels->count())

    @php
    $level = $levels->first();
    $area = $level->area;
    @endphp

    <h5>Area</h5>
    @if ($area->descrizione)
    <p>{{ $area->descrizione }}</p>
    @endif

    @if ($levels->count() == 1)
        @if ($isHoliday && !$level->valido_festivo)
        <h5 class="align-center">Oggi non &egrave; previsto il pagamento per la sosta.</h5>
        @else
        <h5>Dettaglio costi</h5>
        @include('levels.partials.details_single')
        @endif
    @else
        @php
        $area = $levels->first()->area
        @endphp
        <h5 style="display: block;">Dettaglio costi</h5>
        @include('levels.partials.details_multi')
    @endif

@else

<!-- No levels found -->

@endif
