<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Area;
use App\Models\VehicleType;

class Level extends Model
{
    use SoftDeletes;

    protected $table = 'spl_livelli';

    public function area() {
        return $this->belongsTo(Area::class, 'area_id');
    }

    public function vehicle_type() {
        return $this->belongsTo(VehicleType::class, 'tipo_veicolo_id');
    }
}
