<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Models\Park;

class ParkCreated extends Mailable
{
    use Queueable, SerializesModels;
    
    public $user;
    public $park;    

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Park $park)
    {
        $this->park = $park;
        $this->user = $park->user;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.parks.created');
    }
}
