<?php

namespace App\Library;

class FinancialLib {
    
    public static function centToEuro($valore, $stampaValuta = true, $separator = ',') {
        $value = sprintf('%.2f', $valore / 100);
        if ($separator != '.') {
            $value = str_replace('.', ',', $value);
        }
        
        return ($stampaValuta ? '&euro; ' : '') . $value;
    }
    
    public static function centToEuroInt($valore, $stampaValuta = true) {
        return intval(self::centToEuro($valore, $stampaValuta));
    }
    
    public static function euroToCent($valore, $multiply = false) {
        if ($multiply) {
            $valore = $valore * 100;
        }
        
        return str_replace(',', '', $valore);
    }
    
    public static function isFatturabile($utente) {
        return !(empty($utente->codice_fiscale) && empty($utente->piva)) && !is_null($utente->residenza()->first());
    }
}
