<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Validator;

class UserController extends Controller
{
    private $validator;

    public function store(Request $request) {
        if (!$this->isValid($request->input())) {
            return redirect()->back()->withErrors($this->validator)->withInput($request->input());
        }

        session()->put('park', [
            'user' => array_filter($request->input(), function($item) {
                return $item !== '_token';
            }, ARRAY_FILTER_USE_KEY)
        ]);

        return redirect('park/create');
    }

    private function isValid($input) {
        $this->validator = Validator::make($input, [
            'email'     => 'required|email',
            'mobile'    => 'required|digits_between:9,10',
        ], [
            'email.required'        => "",
            'email.email'           => "",
            'mobile.required'       => "",
            'mobile.digits_between' => "Il cellulare deve contenere :min o :max cifre",
        ]);

        return $this->validator->passes();
    }

    public function storePrivate(Request $request) {
        if (!$this->isValidPrivate($request->input())) {
            return redirect()->back()->withErrors($this->validator)->withInput($request->input());
        }

        session()->put('park', [
            'user' => array_filter($request->input(), function($item) {
                return $item !== '_token';
            }, ARRAY_FILTER_USE_KEY)
        ]);

        return redirect('park/create');
    }

    private function isValidPrivate($input) {
        $this->validator = Validator::make($input, [
            'email'     => 'required|email'
        ], [
            'email.required'        => "",
            'email.email'           => ""
        ]);

        return $this->validator->passes();
    }
}
