<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Level;

class LevelController extends Controller
{
    public function getLevels($area_id) {
        $levels = Level::with('area', 'vehicle_type')
            ->where('area_id', $area_id)
            ->get();
        // dd($levels);
        
        $isHoliday = $this->isHoliday();

        return view('levels.index', compact('levels', 'isHoliday'));
    }

    public function getTimeCounter($level_id) {
        $level = Level::find($level_id);

        return view('levels.partials.time_counters', compact('level'));
    }

    private function isHoliday() {
        $array_holidays = array(
            "01-01",
            "06-01",
            "25-04",
            "01-05",
            "02-06",
            "15-08",
            "01-11",
            "08-12",
            "25-12",
            "26-12"
        );

        if (in_array(date('d-m'), $array_holidays))
            return true;
        if (date('d-m') == date('d-m', easter_date()))
            return true; //Pasqua
        if (date('d-m') == date('d-m', easter_date() + 24 * 60 * 60))
            return true; //Pasquetta
        if (date('N') == 7)
            return true;
        return false;
    }
}
